<?php
require_once '../config/database.php';
require_once '../includes/auth_check.php';

header('Content-Type: application/json');

try {
    // Get notification settings from database
    $stmt = $pdo->prepare("SELECT setting_key, setting_value FROM store_settings WHERE setting_key IN ('enable_sms', 'enable_email', 'enable_whatsapp')");
    $stmt->execute();
    $settings = [];
    while ($row = $stmt->fetch()) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
    
    // Debug: Log the raw settings
    error_log("Raw notification settings from DB: " . print_r($settings, true));
    
    $response = [
        'success' => true,
        'settings' => [
            'enable_sms' => $settings['enable_sms'] ?? '0',
            'enable_email' => $settings['enable_email'] ?? '0',
            'enable_whatsapp' => $settings['enable_whatsapp'] ?? '0'
        ]
    ];
    
    // Debug: Log the response
    error_log("Notification settings response: " . print_r($response, true));
    
    echo json_encode($response);
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error loading notification settings: ' . $e->getMessage()
    ]);
}
?> 